#include <iostream>
#include <utility>
#include "r0clib.h"

int _x_end, _y_end;
int _x = 0, _y = 0;
int _moves = 0;
bool _package_picked_up = false;
bool _initialized = false;

static void _initialize() {
    if (_initialized)
        return;
    _initialized = true;
    std::cin >> _x_end >> _y_end;
}

std::pair<int, int> podnies() {
    _initialize();
    if (_package_picked_up) {
        std::cout << "Wielokrotne wywolanie funkcji podnies.\n";
        exit(0);
    }
    _package_picked_up = true;
    return {_x_end, _y_end};
}

void odstaw() {
    _initialize();
    if (!_package_picked_up) {
        std::cout << "Wywolano funkcje odstaw nie podnoszac wczesniej paczki.\n";
        exit(0);
    }
    if (_x == _x_end && _y == _y_end) {
        std::cout << "Robocik postawil paczke w dobrym miejscu w " << _moves << " ruchach.\n";
    } else {
        std::cout << "Robocik postawil paczke w zlym miejscu (" << _x << ", " << _y << ").\n";
    }
    exit(0);
}

void do_przodu() {
    _initialize();
    if (!_package_picked_up) {
        std::cout << "Wywolano funkcje do_przodu nie podnoszac wczesniej paczki.\n";
        exit(0);
    }
    _y++;
    _moves++;
    std::cout << "Robocik idzie do przodu (" << _x << ", " << _y << ").\n";
}

void do_tylu() {
    _initialize();
    if (!_package_picked_up) {
        std::cout << "Wywolano funkcje do_tylu nie podnoszac wczesniej paczki.\n";
        exit(0);
    }
    _y--;
    _moves++;
    std::cout << "Robocik idzie do tylu (" << _x << ", " << _y << ").\n";
}

void w_prawo() {
    _initialize();
    if (!_package_picked_up) {
        std::cout << "Wywolano funkcje w_prawo nie podnoszac wczesniej paczki.\n";
        exit(0);
    }
    _x++;
    _moves++;
    std::cout << "Robocik idzie w prawo (" << _x << ", " << _y << ").\n";
}

void w_lewo() {
    _initialize();
    if (!_package_picked_up) {
        std::cout << "Wywolano funkcje w_lewo nie podnoszac wczesniej paczki.\n";
        exit(0);
    }
    _x--;
    _moves++;
    std::cout << "Robocik idzie w lewo (" << _x << ", " << _y << ").\n";
}
