#include "cho.h"

namespace chozaw {
  const int QUERIES = 222;
  const int SSIZE = 100;

  bool initialized = false;
  int queries = 0;
  std::string hidden;

  void initialize() {
    initialized = true;
    std::cin >> hidden;
  }

  int recytuj(const std::string& s) {
    if(!initialized) initialize();
    queries++;
    if(queries > QUERIES) {
      std::cout << "Za duzo zapytan.\n";
      exit(1);
    }
    if(s.size() != SSIZE) {
      std::cout << "Niewlasciwy rozmiar zapytania.\n";
      exit(1);
    }
    int matched = 0;
    for(int i=0; i<(int)hidden.size(); i++) {
      if(hidden[i] == s[i]) matched++;
    }
    if(matched == SSIZE) {
      std::cout << "OK\n";
      exit(0);
    }
    else {
      int r = rand()%SSIZE; // Prawdziwa implementacja biblioteki nie uzywa funkcji rand().
      if(hidden[r] == s[r]) hidden[r] ^= 1;
    }
    return matched;
  }
}

int recytuj(const std::string& s) {
  return chozaw::recytuj(s);
}
