#include <iostream>
#include <fstream>
#include <vector>
#include <algorithm>
#include <string>
#include <set>
#include <stdexcept>

using namespace std;


///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////


namespace {
struct Edge {
    int a, b, w;
    Edge() {}
    Edge(int a, int b, int w) : a(a), b(b), w(w) {}
};
bool init = false;

vector<Edge> edges;
int n, m;

// Wczytuje dane wejściowe i inicjalizuje zmienne.
void try_init(string x) {
    if (init) return;
    ifstream input(x);
    if (!input) {
        cerr << "Error: Cannot open input file!" << endl;
        exit(1);
    }
    init = true;
    input >> n >> m;
    for (int i = 0; i < m; i++) {
        int a, b, w;
        input >> a >> b >> w;
        edges.emplace_back(a, b, w);
    }
}

// Wypisuje błąd i kończy program.
void send_error(string message) {
    cerr << message << endl;
    exit(0);
}


int DajN() {
    return n;
}

vector<pair<int, int>> DajDrogi() {
    vector<pair<int, int>> res;
    for (const auto& e : edges) {
        res.emplace_back(e.a, e.b);
    }
    return res;
}

int Niezalezne(int a, int b) {
    if (a < 0 || a >= m)
        send_error("Niezalezne: a poza zakresem [0, M)");
    if (b < 0 || b >= m)
        send_error("Niezalezne: b poza zakresem [0, M)");
    if (a == b)
        send_error("Niezalezne: a == b");
    if (edges[a].a == edges[b].a || edges[a].a == edges[b].b ||
        edges[a].b == edges[b].a || edges[a].b == edges[b].b)
        send_error("Niezalezne: krawędzie mają wspólny koniec");
    return edges[a].w < edges[b].w ? -1 : 1;
}

int Gwiazda(vector<int> t) {
    if (t.empty())
        send_error("Gwiazda: t jest puste");
    for (int x : t)
        if (x < 0 || x >= m)
            send_error("Gwiazda: wartość poza zakresem [0, M)");
    
    // Obliczamy przecięcie zbiorów końców krawędzi.
    set<int> s = {edges[t[0]].a, edges[t[0]].b};
    for (int x : t) {
        set<int> new_s;
        for (int y : {edges[x].a, edges[x].b})
            if (s.count(y))
                new_s.insert(y);
        s = new_s;
    }

    if (s.empty())
        send_error("Gwiazda: nie znaleziono wspólnego wierzchołka");

    int result = t[0];
    for (int x : t)
        if (edges[x].w < edges[result].w)
            result = x;
    return result;
}

void Wynik(vector<int> t) {
    cerr << "Wynik: ";
    for (int x : t)
        cerr << x << " ";
    cerr << endl;
}

} // namespace


///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////


int main(int argc, char **argv) {
    if (argc != 2) {
        cerr << "Error: Cannot open input file!" << endl;
        return 1;
    }
    try_init(argv[1]);

    cout << n << " " << m << endl;
    for (auto i : edges) {
        cout << i.a << " " << i.b << endl;
    }

    int typ, k, a, b;

    while (true) {
        cin >> typ;
        if (typ == 1) {
            cin >> a >> b;
            cout << Niezalezne(a, b) << endl;
        } else {
            cin >> k;
            vector <int> t(k);
            for (int i=0; i<k; ++i) {
                cin >> t[i];
            }
            if (typ == 2) {
                cout << Gwiazda(t) << endl;
            } else {
                Wynik(t);
                if (cin >> k) {
                    cerr << "Piszesz po podaniu odp, 0.\n" << endl;
                }
                return 0;
            }
        }
    }
	return 0;
}
