/*************************************************************************/
/*                                                                       */
/*                    V Olimpiada Informatyczna                          */
/*                                                                       */
/*   Rozwizanie zadania: GRA ULAMA                                      */
/*   Plik:                GRA.C                                          */
/*   Autor:               Marcin Mucha                                   */
/*************************************************************************/
#include "gramod.h"
#include "gra.h"
#include <stdio.h>
#include <stdlib.h>


typedef struct{           /* Zbiory prawd i kamstw pamitamy na listach
                             zaimplementowanych w tablicy. */
		int p, k; /* "Wskaniki" na pocztek i koniec listy. */
		int ile;  /* Ile jest elementw w licie. */
	} lista;

int liczby[LICZBA_MAX];
/* Tu bd trzymane listy liczb, implementacja tablicowa. */
lista	lista0, lista1; /* Zbiory, odpowiednio, prawd i kamstw. */
lista	pyt0, pyt1; /* Liczby wybrane do pytania z poszczeglnych list. */
lista	poz0, poz1; /* Pozostae czci list. */


void nowa_gra(){
	int i;

	wiem = NIE;

	for( i = 0; i < LICZBA_MAX - 1; i++)
		liczby[i] = i + 1;
	liczby[LICZBA_MAX - 1] = -1;

	lista0.p = 0;
	lista0.k = LICZBA_MAX - 1;
	lista0.ile = LICZBA_MAX;

	lista1.p = -1;
	lista1.k = -1;
	lista1.ile = 0;
}

static void dziel_liste( lista *l, lista *l1, lista *l2, int ile){
/* Dzieli list l na list l1 zawierajc pierwsze ile elementw i list l2.*/
	int i;
	int elem;

	if( ile > l->ile){ fprintf( stderr, "oj niedobrze\n"); exit(1);}

	if( ile == 0){
		l1->p = -1;
		l1->k = -1;
		l1->ile = 0;
		*l2 = *l;
	} else if( ile == l->ile){
		*l1 = *l;
		l2->p = -1;
		l2->k = -1;
		l2->ile = 0;
	} else{
		elem = l->p;
		for( i = 1; i < ile; i++)
			elem = liczby[elem];

		l1->p = l->p;
		l1->k = elem;
		l1->ile = ile;

		l2->p = liczby[elem];
		l2->k = l->k;
		l2->ile = l->ile - ile;

		liczby[elem] = -1;
	}
}

void lacz_listy( lista *l1, lista *l2, lista *l){
/* czy listy l1, l2 wynik umieszczajc w l. */
	if( l1->ile == 0)
		*l = *l2;
	else if( l2->ile == 0)
		*l = *l1;
	else{
		l->p = l1->p;
		l->k = l2->k;
		l->ile = l1->ile + l2->ile;
		liczby[l1->k] = l2->p;
	}
}

void ustaw( lista *l){
	int i;

	i = l->p;
	while( i != -1){
		pytanie[i] = TAK;
		i = liczby[i];
	}
}

void daj_pytanie(){
	int ile0, ile1; /* Ile liczb wybierzemy do pytania. */
	int i;

	if( !( lista0.ile % 2)){
         /* To przy okazji oznacza : !( lista1.ile % 2) */
	 /* Bierzemy po poowie z obu zbiorw */
		ile0 = lista0.ile / 2;
		ile1 = lista1.ile / 2;
	} else {
	 /* To z kolei znaczy, e lista0.ile = 1 */
		ile0 = 1;
                if ( lista1.ile == 11 ) ile1 = 4;
                if ( lista1.ile == 4 ) ile1 = 1;
                if ( lista1.ile == 1 ) ile1 = 0;
	}
	/* W tym momencie wiemy ju o ile liczb z poszczeglnych
        list bdziemy pyta */
	dziel_liste( &lista0, &pyt0, &poz0, ile0);
	dziel_liste( &lista1, &pyt1, &poz1, ile1);

	for( i = 0; i < LICZBA_MAX; i++)
		pytanie[i] = NIE;

	ustaw( &pyt0);
	ustaw( &pyt1);
}

void analizuj_odpowiedz(){
	if( odpowiedz == TAK){
		lista0 = pyt0;
		lacz_listy( &poz0, &pyt1, &lista1);
	} else {
		lista0 = poz0;
		lacz_listy( &pyt0, &poz1, &lista1);
	}

	if( lista0.ile + lista1.ile == 1){
		wiem = TAK;
		if( lista0.ile == 1)
			x = lista0.p;
		else
			x = lista1.p;
	}
}