#include <iostream>
#include <fstream>
#include <vector>
#include <algorithm>
#include <string>
#include <stdexcept>
using namespace std;

int main(int argc, char **argv) {
    // Otworz plik wejsciowy.
    if (argc != 2) {
        cerr << "Error: Cannot open input file!" << endl;
        return 1;
    }
    ifstream input(argv[1]);
    if (!input) {
        cerr << "Error: Cannot open input file!" << endl;
        return 1;
    }

    // Wczytaj n i tablice.
    int n;
    input >> n;
    vector<int> A(n);
    for (int i = 0; i < n; ++i) {
        input >> A[i];
    }

    // Zamknij plik wejsciowy.
    input.close();

    // Zmienna do zliczania pytan.
    long long m = 0;

    // Wypisz rozmiar tablicy.
    cout << n << endl;

    while (true) {
        // Wczytaj liczbe.
        int i;
        cin >> i;
        if (i == n) {
            // Zakladamy, ze program zawodnika odpowiada
            vector<int> B(n);
            for (int i = 0; i < n; ++i) {
                cin >> B[i];
            }
            if (cin >> i) {
                cerr << "0\% PUNKTOW - Piszesz na wyjscie po zakonczeniu." << endl;
                return 0;
            }
            for (int i = 0; i < n; ++i) {
                if (A[i] != B[i]) {
                    cerr << "ZLA ODPOWIEDZ!" << endl;
                    cerr << "Oczekiwano a[" << i << "] = " << A[i] << ", a otrzymano a[" << i << "] = " << B[i] << endl;
                    cerr << "0\% PUNKTOW" << endl;
                    return 0;
                }
            }
            cerr << "POPRAWNIE ODTWORZONY CIAG" << endl << "Zadano " << m << " pytan" << endl;
            if (m <= n) 
                cerr << "100\% PUNKTOW" << endl;
            else if (m == n + 1)
                cerr << "80\% PUNKTOW" << endl;
            else if (m <= (long long)n * n - n)
                cerr << "50\% PUNKTOW" << endl;
            else
                cerr << "0\% PUNKTOW" << endl;
            return 0;
        }

        int j;
        cin >> j;

        ++m;
        if (i < 0 || j < 0 || i >= n || j >= n || i == j) {
            cerr << "ZLA ODPOWIEDZ" << endl << "Bledne parametry w zapytaniu: i = " << i << ", j = " << j << endl;
            cerr << "0\% PUNKTOW" << endl;
            return 0;
        }

        // Wypisz sume.
        cout << A[i] + A[j] << endl;
    }

    return 0;
}
