import sys


class Edge:
    def __init__(self, a: int, b: int, w: int = 0):
        self.a = a
        self.b = b
        self.w = w


init = False
edges = []
n = 0
m = 0


def try_init():
    global init, n, m, edges
    if init:
        return
    init = True
    n, m = map(int, input().split())
    edges = [Edge(*map(int, input().split())) for _ in range(m)]


def send_error(message: str):
    print(message)
    sys.exit(0)


def DajN() -> int:
    try_init()
    return n


def DajDrogi():
    try_init()
    return [(e.a, e.b) for e in edges]


def Niezalezne(a: int, b: int) -> int:
    try_init()
    if not (0 <= a < m):
        send_error("Niezalezne: a poza zakresem [0, M)")
    if not (0 <= b < m):
        send_error("Niezalezne: b poza zakresem [0, M)")
    if a == b:
        send_error("Niezalezne: a == b")
    if edges[a].a in (edges[b].a, edges[b].b) or edges[a].b in (edges[b].a, edges[b].b):
        send_error("Niezalezne: krawędzie mają wspólny koniec")
    return -1 if edges[a].w < edges[b].w else 1


def Gwiazda(t: list[int]) -> int:
    try_init()
    if not t:
        send_error("Gwiazda: t jest puste")
    if any(x < 0 or x >= m for x in t):
        send_error("Gwiazda: wartość poza zakresem [0, M)")

    s = {edges[t[0]].a, edges[t[0]].b}
    for x in t:
        s.intersection_update({edges[x].a, edges[x].b})

    if not s:
        send_error("Gwiazda: nie znaleziono wspólnego wierzchołka")

    return min(t, key=lambda x: edges[x].w)


def Wynik(t: list[int]):
    try_init()
    print("Wynik:", " ".join(map(str, t)))
