#include "redlib.h"
#include <iostream>

using namespace std;

namespace {
    bool init = false;
    vector<Edge> edges;
    int n, m;

    void try_init() {
        if (init) return;
        init = true;
        cin >> n >> m;
        for (int i = 0; i < m; i++) {
            int a, b, w;
            cin >> a >> b >> w;
            edges.emplace_back(a, b, w);
        }
    }

    void send_error(const string& message) {
        cout << message << endl;
        exit(0);
    }
}

// Konstruktor domyślny
Edge::Edge() {}

// Konstruktor inicjalizujący
Edge::Edge(int a, int b, int w) : a(a), b(b), w(w) {}

int DajN() {
    try_init();
    return n;
}

vector<pair<int, int>> DajDrogi() {
    try_init();
    vector<pair<int, int>> res;
    for (const auto& e : edges) {
        res.emplace_back(e.a, e.b);
    }
    return res;
}

int Niezalezne(int a, int b) {
    try_init();
    if (a < 0 || a >= m)
        send_error("Niezalezne: a poza zakresem [0, M)");
    if (b < 0 || b >= m)
        send_error("Niezalezne: b poza zakresem [0, M)");
    if (a == b)
        send_error("Niezalezne: a == b");
    if (edges[a].a == edges[b].a || edges[a].a == edges[b].b ||
        edges[a].b == edges[b].a || edges[a].b == edges[b].b)
        send_error("Niezalezne: krawędzie mają wspólny koniec");
    return edges[a].w < edges[b].w ? -1 : 1;
}

int Gwiazda(vector<int> t) {
    try_init();
    if (t.empty())
        send_error("Gwiazda: t jest puste");
    for (int x : t)
        if (x < 0 || x >= m)
            send_error("Gwiazda: wartość poza zakresem [0, M)");

    set<int> s = {edges[t[0]].a, edges[t[0]].b};
    for (int x : t) {
        set<int> new_s;
        for (int y : {edges[x].a, edges[x].b})
            if (s.count(y))
                new_s.insert(y);
        s = new_s;
    }

    if (s.empty())
        send_error("Gwiazda: nie znaleziono wspólnego wierzchołka");

    int result = t[0];
    for (int x : t)
        if (edges[x].w < edges[result].w)
            result = x;
    return result;
}

void Wynik(vector<int> t) {
    try_init();
    cout << "Wynik: ";
    for (int x : t)
        cout << x << " ";
    cout << endl;
}