import numpy as np
import matplotlib.colors as mcolors
import matplotlib.pyplot as plt
import matplotlib.animation as animation

def get_initial_state():
    return np.array([list(input()) for i in range(100)], dtype=float)

def apply_rule(grid):
    new_grid = np.copy(grid)
    size = grid.shape[0]
    
    for i in range(size - 1):
        for j in range(size - 1):
            square = grid[i:i+2, j:j+2]
            ones = np.argwhere(square == 1)
            
            if len(ones) == 2:
                if abs(ones[0][0] - ones[1][0]) == 1 and abs(ones[0][1] - ones[1][1]) == 1:
                    new_grid[i:i+2, j:j+2] = 1 - square  
    
    return new_grid

def visualise_evolution(size=100):
    plt.rcParams['toolbar'] = 'None'
    fig, ax = plt.subplots()
    grid = get_initial_state()
    seen_states = set()
    step_count = 0
    img = ax.imshow(grid, cmap = mcolors.LinearSegmentedColormap.from_list("custom_gradient", ["#ECEFF4", "#5E81AC"]), interpolation='nearest')
    ax.set_xticks([])
    ax.set_yticks([])
    ax.set_frame_on(False)
    
    def update(frame):
        nonlocal grid, step_count
        img.set_data(grid)
        ax.set_title(f'Sekunda: {step_count}')
        
        grid_bytes = grid.tobytes()
        if grid_bytes in seen_states:
            print(f'Koniec po sekundzie: {len(seen_states)}')
            ani.event_source.stop()
            return
        
        seen_states.add(grid_bytes)
        new_grid = apply_rule(grid)
        
        transition_frames = 25
        for i in range(transition_frames):
            grid = grid + (new_grid - grid) * (1 / (transition_frames - i))
            img.set_data(grid)
            plt.pause(0.05)
        
        img.set_data(grid)
        step_count += 1
    
    ani = animation.FuncAnimation(fig, update, interval=200)
    plt.show()

visualise_evolution()
