#include <vector>
#include <iostream>
#include "zerlib.h"

namespace {
    bool initialized = false;
    int n, m;
    std::vector<int> A;

    void initialize() {
        if (!initialized) {
            std::cin >> n;
            A.resize(n);
            for (int i = 0; i < n; ++i)
                std::cin >> A[i];
            initialized = true;
        }
    }
}

int daj_n() {
    if (!initialized) {
        initialize();
    }
    return n;
}

int suma(int i, int j) {
    if (!initialized)
        initialize();
    if (i < 0 || j < 0 || i >= n || j >= n || i == j) {
        std::cout << "ZLA ODPOWIEDZ" << std::endl << "Bledne parametry w zapytaniu: i = " << i << ", j = " << j << std::endl;
        std::cout << "0\% PUNKTOW" << std::endl;
        exit(0);
    }
    ++m;
    return A[i] + A[j];
}

void odpowiedz(std::vector<int> a) {
    if (!initialized)
        initialize();
    for (int i = 0; i < n; ++i)
        if (A[i] != a[i]) {
            std::cout << "ZLA ODPOWIEDZ!" << std::endl;
            std::cout << "Oczekiwano a[" << i << "] = " << A[i] << ", a otrzymano a[" << i << "] = " << a[i] << std::endl;
            std::cout << "0\% PUNKTOW" << std::endl;
            exit(0);
        }
    std::cout << "POPRAWNIE ODTWORZONY CIAG" << std::endl << "Zadano " << m << " pytan" << std::endl;
    if (m <= n) 
        std::cout << "100\% PUNKTOW" << std::endl;
    else if (m == n + 1)
        std::cout << "80\% PUNKTOW" << std::endl;
    else if (m <= (long long)n * n - n)
        std::cout << "50\% PUNKTOW" << std::endl;
    else
        std::cout << "0\% PUNKTOW" << std::endl;
}
