{*************************************************************************}
{*                                                                       *}
{*                    V Olimpiada Informatyczna                          *}
{*                                                                       *}
{*   Rozwizanie zadania: GRA ULAMA                                      *}
{*   Plik:                GRA.PAS                                        *}
{*   Autor:               Marcin Mucha                                   *}
{*************************************************************************}

unit gra;
{ Modu wzorcowy do zadania "Gra Ulama".    }

interface

procedure nowa_gra;
procedure daj_pytanie;
procedure analizuj_odpowiedz;

implementation

uses
   gramod;

type
   lista = record    { Zbiory prawd i kamstw pamitamy na listach
                       zaimplementowanych w tablicy. }
      p, k : integer; { "Wskaniki" na pocztek i koniec listy. }
      ile : integer; { Ile jest elementw w licie. }
   end;

var
   liczby : array[0..LICZBA_MAX-1] of integer;
   { Tu bd trzymane listy liczb, implementacja tablicowa. }
   lista0, lista1 : lista; { Zbiory, odpowiednio, prawd i kamstw. }
   pyt0, pyt1 : lista; { Liczby wybrane do pytania z poszczeglnych list. }
   poz0, poz1 : lista; { Pozostae czci list. }

procedure nowa_gra;
var
   i : integer;
begin

   wiem := NIE;

   for i := 0 to LICZBA_MAX - 2 do liczby[i] := i + 1;
   liczby[LICZBA_MAX - 1] := -1;

   lista0.p := 0;
   lista0.k := LICZBA_MAX - 1;
   lista0.ile := LICZBA_MAX;

   lista1.p := -1;
   lista1.k := -1;
   lista1.ile := 0;
end;

procedure dziel_liste( var l, l1, l2 : lista; ile : integer);
{ Dzieli list l na list l1 zawierajc pierwsze ile elementw i list l2. }
var
   i : integer;
   elem : integer;
begin
   if ile > l.ile then begin writeln( 'oj niedobrze'); halt end;

   if ile = 0 then
      begin
         l1.p := -1;
         l1.k := -1;
         l1.ile := 0;
         l2 := l
      end
   else if ile = l.ile then
      begin
         l1 := l;
         l2.p := -1;
         l2.k := -1;
         l2.ile := 0
      end
   else
      begin
         elem := l.p;
         for i := 1 to ile - 1 do elem := liczby[elem];

         l1.p := l.p;
         l1.k := elem;
         l1.ile := ile;

         l2.p := liczby[elem];
         l2.k := l.k;
         l2.ile := l.ile - ile;

         liczby[elem] := -1
      end
end;

procedure lacz_listy( var l1, l2, l : lista);
{ czy listy l1, l2 wynik umieszczajc w l }
begin
   if l1.ile = 0 then
      l := l2
   else if l2.ile = 0 then
      l := l1
   else
      begin
         l.p := l1.p;
         l.k := l2.k;
         l.ile := l1.ile + l2.ile;
         liczby[l1.k] := l2.p
      end
end;

procedure ustaw( var l : lista);
var
   i : integer;
begin
   i := l.p;
   while i <> -1 do
      begin
         pytanie[i] := TAK;
         i := liczby[i]
      end
end;

procedure daj_pytanie;
var
   ile0, ile1 : integer; { Ile liczb wybierzemy do pytania. }
   i : integer;
begin
   if not odd( lista0.ile) then
   { To przy okazji oznacza : not odd( lista1.ile) }
      begin { Bierzemy po poowie z obu zbiorw }
         ile0 := lista0.ile div 2;
         ile1 := lista1.ile div 2
      end
   else
      begin { To z kolei znaczy, e lista0.ile = 1. }
         ile0 := 1;
         case lista1.ile of
          11  : ile1 := 4;
           4  : ile1 := 1;
           1  : ile1 := 0
         end
      end;
   { W tym momencie wiemy ju o ile liczb z poszczeglnych list
     bdziemy pyta. }

   dziel_liste( lista0, pyt0, poz0, ile0);
   dziel_liste( lista1, pyt1, poz1, ile1);

   for i := 0 to LICZBA_MAX - 1 do pytanie[i] := NIE;

   ustaw( pyt0);
   ustaw( pyt1)
end;

procedure analizuj_odpowiedz;
begin
   if odpowiedz = TAK then
      begin
         lista0 := pyt0;
         lacz_listy( poz0, pyt1, lista1)
      end
   else
      begin
         lista0 := poz0;
         lacz_listy( pyt0, poz1, lista1)
      end;

   if lista0.ile + lista1.ile = 1 then
      begin
         wiem := TAK;
         if lista0.ile = 1 then
            x := lista0.p
         else
            x := lista1.p
      end
end;

begin
end.

